<?xml version="1.0"?>
<!-- Written by Peter Mertens "peter@pmertens.de" -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output method="xml" indent="yes"/>
	<xsl:template match="/Depotbestand">
		<xsl:comment>erstellt mittels "depotbestand-verdichtung-xml.xsl"</xsl:comment>
		<xsl:processing-instruction name="xml-stylesheet">href="depotbestand-html.xsl" type="text/xsl"</xsl:processing-instruction>
		<xsl:processing-instruction name="cocoon-process">type="xslt"</xsl:processing-instruction>
		<xsl:copy>
			<xsl:apply-templates select="Bestand|@*"/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="Bestand">
		<xsl:copy>
			<xsl:apply-templates select="Papiertyp|Kennnummer|Bezeichnung|Stueckzahl|Nennwert|Kurs|Waehrung|Zins|Faellig|@*"/>
			<xsl:element name="Wert">
				<xsl:if test='Papiertyp="Aktie" or Papiertyp="Fond"'>
					<xsl:value-of select="Stueckzahl*Kurs"/>
				</xsl:if>
				<xsl:if test='Papiertyp="Rentenpapier"'>
					<xsl:value-of select="Nennwert*Kurs*0.01"/>
				</xsl:if>
			</xsl:element>
			<xsl:element name="Zinsfluss">
				<xsl:if test='Papiertyp="Rentenpapier"'>
					<xsl:value-of select="Nennwert*Zins*0.01"/>
				</xsl:if>
			</xsl:element>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="Papiertyp|Kennnummer|Bezeichnung|Stueckzahl|Nennwert|Kurs|Waehrung|Zins|Faellig">
		<xsl:apply-templates select="@*"/>
		<xsl:copy>
			<xsl:value-of select="."/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="@*">
		<xsl:copy/>
	</xsl:template>
</xsl:stylesheet>
